/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.structures.rss;

import java.util.HashSet;
import java.util.Set;

public class SujetBrut extends Sujet {
    private BaseRSSItem[] urls = new BaseRSSItem[]{};

    public SujetBrut(int id, String titre) {
        super(id, titre);
    }

    public BaseRSSItem[] getArticles() {
        return urls;
    }

    public void setArticles(BaseRSSItem[] urls) {
        this.urls = urls;
    }

    @Override
    public int hashCode(){
        int n = 0;
        for(int i=0; i<urls.length; i++){
            n += urls[i].hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object o){
        if(o == null){
            return false;
        }
        if(!(o instanceof SujetBrut)){
            return false;
        }
        SujetBrut s = (SujetBrut)o;
        boolean result = false;
        int idem = 0;
        for(int i=0; i<urls.length; i++){
            for(int j=0; j<s.urls.length; j++){
                if(urls[i].getLink().equals(s.urls[j].getLink())){
                    idem++;
                }
            }
        }
        // les sujets sont considérés égaux s'ils ont au moins 50% de la taille
        // du plus petit sujet en urls communes
        if (idem >= Math.min(urls.length, s.urls.length) * 5 / 10) {
            result = true;
        }
        return result;
    }

    public void fusionne(SujetBrut s){
        Set<BaseRSSItem> liste = new HashSet<BaseRSSItem>();
        for(int i=0; i<urls.length; i++){
            liste.add(urls[i]);
        }
        for(int i=0; i<s.urls.length; i++){
            liste.add(s.urls[i]);
        }
        BaseRSSItem[] x = new BaseRSSItem[liste.size()];
        liste.toArray(x);
        urls = x;
    }

    @Override
    public String toString(){
        String s = getTitre();
        if(s.contains(" - ")){
            String[] ss = s.split(" - ");
            s = "";
            for(int i=0; i<ss.length-1; i++){
                s += ss[i];
            }
        }
        return "[" + urls.length + " articles] " + s ;
    }


}
